#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 ec_pos;
out vec3 normal;
out vec2 uv;
out vec2 offset;

void main()
{
	uv = TEXCOORD*0.5;

	//float time = 0.5;
	float a = time*8.0 + length(POSITION.xz)*(1.0/128.0);
	vec2 angles = POSITION.xz*(1.0/128.0) + vec2(sin(a), cos(a));
	offset = vec2(cos(angles.x), sin(angles.y))*0.25;
	normal = NormalMatrix * vec3(0.0, 1.0, 0.0); //NORMAL;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
